unit ViewForm;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes,
  Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls,
  Interfaces;

type
  TfrmView = class(TForm, IViewForm)
    lbName: TLabel;
    lbAddress: TLabel;
    lbCity: TLabel;
    lbAge: TLabel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    FSubscriptionId: Integer;
    procedure UpdatePersonData(aPerson: IPerson);
    procedure SetObserver;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Show;  // IViewForm
    procedure Close; // IViewForm
  end;

implementation

uses
  System.Messaging,
  Constants;

{$R *.dfm}

constructor TfrmView.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  SetObserver;
end;

procedure TfrmView.FormCreate(Sender: TObject);
begin
  // Inizializzazione labels
  lbName.Caption := '';
  lbAddress.Caption := '';
  lbCity.Caption := '';
  lbAge.Caption := '';
end;

procedure TfrmView.FormDestroy(Sender: TObject);
begin
  // Rimuove la sottoscrizione ai messaggi
  TMessageManager.DefaultManager.Unsubscribe(TPersonData, FSubscriptionId);
end;

procedure TfrmView.SetObserver;
begin
  FSubscriptionId := TMessageManager.DefaultManager.SubscribeToMessage(TPersonData,
    procedure(const Sender: TObject; const aMessage: TMessage)
    var
      lPerson: IPerson;
    begin
      lPerson := TPersonData(aMessage).Value;
      UpdatePersonData(lPerson);
    end);
end;

procedure TfrmView.UpdatePersonData(aPerson: IPerson);
begin
  if Assigned(aPerson) then
  begin
    lbName.Caption := aPerson.Name;
    lbAddress.Caption := aPerson.Address;
    lbCity.Caption := aPerson.City;
    lbAge.Caption := aPerson.Age.ToString;
  end;
end;

procedure TfrmView.Show;
begin
  inherited Show;
end;

procedure TfrmView.Close;
begin
  inherited Close;
end;

end.
