unit MainForm;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils,
  System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  System.Actions, Vcl.ActnList, Vcl.StdCtrls,
  Interfaces;

type
  TfrmMain = class(TForm)
    lbName: TLabel;
    lbAddress: TLabel;
    lbCity: TLabel;
    lbAge: TLabel;
    btnAddPerson: TButton;
    ActionList1: TActionList;
    acAddPerson: TAction;
    acModifyPerson: TAction;
    btnModifyPerson: TButton;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure acAddPersonExecute(Sender: TObject);
    procedure acModifyPersonExecute(Sender: TObject);
    procedure ActionList1Update(Action: TBasicAction; var Handled: Boolean);
  private
    FWritePerson: Boolean;
    FViewForm: IViewForm;
    FSubscriptionId: Integer;
    procedure WritePerson(aPerson: IPerson);
    procedure AddModifyPerson(aPerson: IPerson = nil);
    procedure SetObservers;
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses
  System.Messaging,
  Constants,
  Factory;

{$R *.dfm}

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  // Rimuove la sottoscrizione ai messaggi per evitare access violation
  TMessageManager.DefaultManager.Unsubscribe(TPersonData, FSubscriptionId);
  inherited;
end;

procedure TfrmMain.acAddPersonExecute(Sender: TObject);
begin
  AddModifyPerson();
end;

procedure TfrmMain.acModifyPersonExecute(Sender: TObject);
var
  lPerson: IPerson;
begin
  lPerson := TFactory.GetPerson;
  lPerson.Name := lbName.Caption;
  lPerson.Address := lbAddress.Caption;
  lPerson.City := lbCity.Caption;
  lPerson.Age := String(lbAge.Caption).toInteger;
  AddModifyPerson(lPerson);
end;

procedure TfrmMain.ActionList1Update(Action: TBasicAction; var Handled: Boolean);
begin
  acModifyPerson.Enabled := FWritePerson;
end;

procedure TfrmMain.AddModifyPerson(aPerson: IPerson);
var
  lEditor: IPersonEditor;
begin
  lEditor := TFormFactory.CreatePersonEditor(aPerson);
  lEditor.Execute;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  SetObservers;
  FWritePerson := false;

  // Crea e mostra la ViewForm tramite factory
  FViewForm := TFormFactory.CreateViewForm;
  FViewForm.Show;
end;

procedure TfrmMain.SetObservers;
begin
   FSubscriptionId := TMessageManager.DefaultManager.SubscribeToMessage(TPersonData,
    procedure(const Sender: TObject; const aMessage: TMessage)
    begin
      FWritePerson := true;
      var
      lPerson := TPersonData(aMessage).Value;
      WritePerson(lPerson);
    end);
end;

procedure TfrmMain.WritePerson(aPerson: IPerson);
begin
  lbName.Caption := aPerson.Name;
  lbAddress.Caption := aPerson.Address;
  lbCity.Caption := aPerson.City;
  lbAge.Caption := aPerson.Age.ToString;
end;

end.
