unit Factory;

interface

uses
  Interfaces;

type
  TFactory = class
  public
    class function GetPerson: IPerson;
  end;

  TFormFactory = class
  public
    class function CreatePersonEditor(aPerson: IPerson = nil): IPersonEditor;
    class function CreateViewForm: IViewForm;
  end;

implementation

uses
  BusinessObjects,
  AddPersonForm,
  ViewForm;

{ TFormFactory }

class function TFormFactory.CreatePersonEditor(aPerson: IPerson): IPersonEditor;
begin
  Result := TfrmAddModifyPerson.Create(aPerson);
end;

class function TFormFactory.CreateViewForm: IViewForm;
begin
  Result := TfrmView.Create(nil);
end;

{ TFactory }

class function TFactory.GetPerson: IPerson;
begin
  Result := TPerson.Create;
end;

end.
