unit BusinessObjects;

interface

uses
  Interfaces;

type
  TPerson = class(TInterfacedObject, IPerson)
  private
    FName: String;
    FAge: Integer;
    FAddress: String;
    FCity: String;
    procedure SetAddress(const Value: String);
    procedure SetAge(const Value: Integer);
    procedure SetCity(const Value: String);
    procedure SetName(const Value: String);
    function GetAddress: String;
    function GetAge: Integer;
    function GetCity: String;
    function GetName: String;
  public
    property Name: String read GetName write SetName;
    property City: String read GetCity write SetCity;
    property Address: String read GetAddress write SetAddress;
    property Age: Integer read GetAge write SetAge;
  end;

implementation

{ TPerson }

function TPerson.GetAddress: String;
begin
  Result := FAddress;
end;

function TPerson.GetAge: Integer;
begin
  Result := FAge;
end;

function TPerson.GetCity: String;
begin
  Result := FCity;
end;

function TPerson.GetName: String;
begin
  Result := FName;
end;

procedure TPerson.SetAddress(const Value: String);
begin
  FAddress := Value;
end;

procedure TPerson.SetAge(const Value: Integer);
begin
  FAge := Value;
end;

procedure TPerson.SetCity(const Value: String);
begin
  FCity := Value;
end;

procedure TPerson.SetName(const Value: String);
begin
  FName := Value;
end;

end.
