unit ThreadUnit;

interface

uses
  System.Classes, System.SysUtils, System.Messaging, Commons;

type

  TRandomThread = class(TThread)
  private
    FRandomValue: Integer;
    FWaitTime: Integer;
  protected
    procedure Execute; override;
    procedure SendProgressUpdate;
  public
    constructor Create;
  end;

implementation

constructor TRandomThread.Create;
begin
  inherited Create(True); // Crea sospeso
  // Imposta la priorit del thread
  Priority := tpNormal;
end;

procedure TRandomThread.Execute;
begin
  try
    while not terminated do
    begin
      // Genera un tempo di attesa casuale tra 3 e 7 secondi
      FWaitTime := 500 + Random(2001); // 500-2500 millisecondi

      // Simula un processo lungo
      Sleep(FWaitTime);

      // Genera un valore casuale tra 0 e 100
      FRandomValue := Random(101); // 0-100

      // Invia il messaggio
      Synchronize(SendProgressUpdate);
    end;
  except
    on E: Exception do
      // Gestione errori
  end;
end;

procedure TRandomThread.SendProgressUpdate;
begin
  // Pubblica il messaggio tramite il message manager
  var
  lMessage := TProgressUpdateMessage.Create(FRandomValue);
  TMessageManager.DefaultManager.SendMessage(Self, lMessage);
end;

end.
