unit SecondForm;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ComCtrls;

type
  TfrmSecond = class(TForm)
    ProgressBar1: TProgressBar;
    mmRecord: TMemo;
    Button1: TButton;
  private
    FCalc: Integer;
    FSubscriptionId: Integer;
    procedure SetObserver;
    procedure FormCreate(Sender: TObject);
  public
    constructor Create(AOwner: TComponent; aCalc: Integer);
    destructor Destroy; override;
  end;

var
  frmSecond: TfrmSecond;

implementation

uses
  System.Messaging, Commons;

{$R *.dfm}

constructor TfrmSecond.Create(AOwner: TComponent; aCalc: Integer);
begin
  inherited Create(AOwner);
  FCalc := aCalc;
  SetObserver;
end;

destructor TfrmSecond.Destroy;
begin
  // Rimuove la sottoscrizione ai messaggi per evitare access violation
  TMessageManager.DefaultManager.Unsubscribe(TProgressUpdateMessage, FSubscriptionId);
  inherited;
end;

procedure TfrmSecond.FormCreate(Sender: TObject);
begin

end;

procedure TfrmSecond.SetObserver;
begin
  FSubscriptionId := TMessageManager.DefaultManager.SubscribeToMessage(TProgressUpdateMessage,
    procedure(const Sender: TObject; const aMessage: TMessage)
    var
      lValue: Integer;
    begin
      lValue := TProgressUpdateMessage(aMessage).Value div FCalc;
      // Aggiorna la progress bar con il valore ricevuto dal thread
      ProgressBar1.Position := lValue;

      var
      lMsg := formatDateTime('hh:nn:ss:zzz - ', now) + lValue.ToString;

      mmRecord.Lines.insert(0, lMsg);
    end);
end;

end.
