unit MainForm;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.ComCtrls, ThreadUnit, Vcl.ExtCtrls;

type
  TfrmMain = class(TForm)
    btnListen: TButton;
    Panel1: TPanel;
    plFrm1: TPanel;
    plFrm2: TPanel;
    ProgressBar1: TProgressBar;
    Button1: TButton;
    Label1: TLabel;
    procedure FormDestroy(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure btnListenClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    FRandomThread: TRandomThread;
    procedure AddFormToPanel(aPanel: TPanel; const aCalc: Integer);
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses
  System.Messaging,
  Commons,
  SecondForm;

{$R *.dfm}

procedure TfrmMain.FormDestroy(Sender: TObject);
begin
  if Assigned(FRandomThread) then
  begin
    FRandomThread.Terminate;  // Segnala al thread di terminare
    FRandomThread.WaitFor;    // Attendi che il thread finisca
    FRandomThread.Free;       // Libera la memoria
  end;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
begin
  AddFormToPanel(plFrm1, 1);
  AddFormToPanel(plFrm2, 2);

  TMessageManager.DefaultManager.SubscribeToMessage(TProgressUpdateMessage,
    procedure(const Sender: TObject; const aMessage: TMessage)
    var
      lValue: Integer;
    begin

      lValue := TProgressUpdateMessage(aMessage).Value;
      // Aggiorna la progress bar con il valore ricevuto dal thread
      ProgressBar1.Position := lValue;
      Label1.Caption := lValue.ToString;
    end);

end;

procedure TfrmMain.AddFormToPanel(aPanel: TPanel; const aCalc: Integer);
var
  lForm: TfrmSecond;
begin
  lForm := TfrmSecond.Create(aPanel, aCalc);
  lForm.Parent := aPanel;
  lForm.Align := alClient;
end;

procedure TfrmMain.btnListenClick(Sender: TObject);
begin
  if btnListen.Tag = 0 then
  begin
    btnListen.Caption := 'Stop Listen';
    btnListen.Tag := 1;
    // Crea e avvia un nuovo thread
    FRandomThread := TRandomThread.Create;
    FRandomThread.FreeOnTerminate := False;  // Gestione manuale della memoria
    FRandomThread.Start;


  end
  else
  begin
    btnListen.Tag := 0;
    btnListen.Caption := 'Listen';
    if Assigned(FRandomThread) then
    begin
      FRandomThread.Terminate;  // Segnala al thread di terminare
      FRandomThread.WaitFor;    // Attendi che il thread finisca
      FRandomThread.Free;       // Libera la memoria
      FRandomThread := nil;     // Previeni dangling pointer
    end;
  end;

end;

procedure TfrmMain.Button1Click(Sender: TObject);
begin
  var I := 0;
  while True do
  begin
    inc(I);
    ProgressBar1.Position := I;
    if I = ProgressBar1.Max then
      I := 0;
    sleep(250);
    Application.ProcessMessages;
  end;
end;

end.
