unit AddPersonForm;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Vcl.Buttons, System.Classes,
  Interfaces;

type
  TfrmAddModifyPerson = class(TForm)
    edName: TEdit;
    Label1: TLabel;
    edAddress: TEdit;
    Label2: TLabel;
    edCity: TEdit;
    Label3: TLabel;
    edAge: TEdit;
    Label4: TLabel;
    btnOK: TBitBtn;
    btnCance: TBitBtn;
    procedure btnOKClick(Sender: TObject);
  private
  public
    constructor create(aPerson: IPerson);
  end;

implementation

uses
  System.Messaging,
  Factory,
  Constants;

{$R *.dfm}

procedure TfrmAddModifyPerson.btnOKClick(Sender: TObject);
var
  lPerson: IPerson;
begin
  lPerson := TFactory.GetPerson;
  lPerson.Name := edName.Text;
  lPerson.Address := edAddress.Text;
  lPerson.City := edCity.Text;
  lPerson.Age := String(edAge.Text).toInteger;

  TMessageManager.DefaultManager.SendMessage(Self, TPersonData.create(lPerson));
end;

constructor TfrmAddModifyPerson.create(aPerson: IPerson);
begin
  inherited create(nil);

  if Assigned(aPerson) then
  begin
    Self.Caption := 'Modify Person';
    edName.Text := aPerson.Name;
    edAddress.Text := aPerson.Address;
    edCity.Text := aPerson.City;
    edAge.Text := aPerson.Age.ToString;
  end;
end;

end.
