unit BaseForm;

interface

uses
  Winapi.Windows, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics, Vcl.Controls,
  Vcl.Forms, Vcl.Dialogs,
  Vcl.StdCtrls,
  System.Messaging;

type
  TBaseMessageForm = class(TForm)
    lbMessage: TLabel;
    edMessage: TEdit;
    btnButton1: TButton;
    btnButton2: TButton;
    procedure FormCreate(Sender: TObject); virtual;
    procedure FormDestroy(Sender: TObject); virtual;
    procedure btnButton1Click(Sender: TObject);
    procedure btnButton2Click(Sender: TObject);
  private
    FSubscriptionId: Integer;
  protected
    // Metodo astratto che ogni form derivata deve implementare
    function GetMessageType: TClass; virtual; abstract;
    // Metodi astratti per creare i messaggi
    function CreateMessageForButton1: TMessage; virtual; abstract;
    function CreateMessageForButton2: TMessage; virtual; abstract;
    // Metodo virtuale per gestire i messaggi ricevuti
    procedure OnMessageReceived(const aMessage: TMessage); virtual;
    // Metodo helper per ottenere il testo completo del messaggio
    function GetMessageText(const aFromText: String): String;
  public
  end;

implementation

{$R *.dfm}

procedure TBaseMessageForm.FormCreate(Sender: TObject);
begin
  inherited;
  // Sottoscrizione al tipo di messaggio specifico della form derivata
  FSubscriptionId := TMessageManager.DefaultManager.SubscribeToMessage(GetMessageType,
    procedure(const Sender: TObject; const aMessage: TMessage)
    begin
      OnMessageReceived(aMessage);
    end);
end;

procedure TBaseMessageForm.FormDestroy(Sender: TObject);
begin
  // Disottoscrizione dal messaggio
  TMessageManager.DefaultManager.Unsubscribe(GetMessageType, FSubscriptionId);
  inherited;
end;

procedure TBaseMessageForm.OnMessageReceived(const aMessage: TMessage);
begin
  // Implementazione di default: aggiorna la label con il valore del messaggio
  if aMessage is GetMessageType then
    lbMessage.Caption := TMessage<String>(aMessage).Value;
end;

procedure TBaseMessageForm.btnButton1Click(Sender: TObject);
begin
  var lMessage := CreateMessageForButton1;
  TMessageManager.DefaultManager.SendMessage(Self, lMessage);
end;

procedure TBaseMessageForm.btnButton2Click(Sender: TObject);
begin
  var lMessage := CreateMessageForButton2;
  TMessageManager.DefaultManager.SendMessage(Self, lMessage);
end;

function TBaseMessageForm.GetMessageText(const aFromText: String): String;
begin
  Result := edMessage.Text + aFromText;
end;

end.
