unit ProductForm;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils,
  System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, System.Actions, Vcl.ActnList,
  Vcl.NumberBox, Vcl.StdCtrls;

type
  TfrmProduct = class(TForm)
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    btnSave: TButton;
    btnLoad: TButton;
    edCode: TEdit;
    edDescription: TEdit;
    edId: TNumberBox;
    ActionList1: TActionList;
    acLoad: TAction;
    acSave: TAction;
    edPrice: TNumberBox;
    acClose: TAction;
    btnClose: TButton;
    procedure FormCreate(Sender: TObject);
    procedure acCloseExecute(Sender: TObject);
    procedure acLoadExecute(Sender: TObject);
    procedure acSaveExecute(Sender: TObject);
    procedure acSaveUpdate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;


implementation

uses
  BusinessObjects,
  dmData,
  Utility;

{$R *.dfm}

procedure TfrmProduct.FormCreate(Sender: TObject);
var
  lProduct: TProduct;
begin
  lProduct:= TProduct.Create;
  try
    // Imposta automaticamente MaxLength di tutti i TEdit
    // basandosi sugli attributi StringLength delle propriet
    TUtility.BindControlsToObject(lProduct, Self, 'ed');

    // A questo punto edName.MaxLength sar gi impostato a 50
  finally
    lProduct.Free;
  end;
end;

procedure TfrmProduct.acCloseExecute(Sender: TObject);
begin
  ModalResult := mrOK;
end;

procedure TfrmProduct.acLoadExecute(Sender: TObject);
var
  lProduct: TProduct;
begin
  lProduct:= TProduct.Create;
  try
    TUtility.LoadFromDatabase(lProduct, dm_Data.FDQuery1, edId.ValueInt);

    edCode.Text := lProduct.Code;
    edDescription.Text := lProduct.Description;
    edPrice.ValueCurrency := lProduct.Price;

  finally
    lProduct.Free;
  end;
end;

procedure TfrmProduct.acSaveExecute(Sender: TObject);
var
  lProduct: TProduct;
begin
  lProduct:= TProduct.Create;
  try
    TUtility.LoadFromDatabase(lProduct, dm_Data.FDQuery1, edId.ValueInt);

    lProduct.Id := edId.ValueInt;  // 0 per nuovo record, >0 per update
    lProduct.Code := edCode.Text;
    lProduct.Description := edDescription.Text;
    lProduct.Price := edPrice.ValueCurrency;

    TUtility.SaveToDatabase(lProduct, dm_Data.FDQuery1);

  finally
    lProduct.Free;
  end;
end;

procedure TfrmProduct.acSaveUpdate(Sender: TObject);
begin
  acLoad.Enabled := edId.ValueInt > 0;
  acSave.Enabled := TUtility.MandatoryOK(self);
end;

end.
