unit MainForm;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils,
  System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  System.Actions, Vcl.ActnList,
  Vcl.StdCtrls, Vcl.NumberBox;

type
  TfrmMain = class(TForm)
    btnSave: TButton;
    btnLoad: TButton;
    ActionList1: TActionList;
    acLoad: TAction;
    acSave: TAction;
    edName: TEdit;
    edSurname: TEdit;
    edAge: TNumberBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    edId: TNumberBox;
    Label5: TLabel;
    edZipCode: TEdit;
    Label6: TLabel;
    edCity: TEdit;
    Label7: TLabel;
    edState: TEdit;
    btnPrice: TButton;
    acProduct: TAction;
    cbTitle: TComboBox;
    Label8: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure acLoadExecute(Sender: TObject);
    procedure acProductExecute(Sender: TObject);
    procedure acSaveExecute(Sender: TObject);
    procedure acSaveUpdate(Sender: TObject);
  private
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses
  Utility,
  BusinessObjects,
  dmData,
  ProductForm,
  Commons,
  Helpers;

{$R *.dfm}

procedure TfrmMain.FormCreate(Sender: TObject);
var
  lPerson: TPerson;
  lPersonType: TPersonType;
begin
  cbTitle.Items := lPersonType.GetList;

  lPerson := TPerson.Create;
  try
    // Imposta automaticamente MaxLength di tutti i TEdit
    // basandosi sugli attributi StringLength delle propriet
    TUtility.BindControlsToObject(lPerson, Self, 'ed');

    // A questo punto edName.MaxLength sar gi impostato a 50
  finally
    lPerson.Free;
  end;
end;

procedure TfrmMain.acLoadExecute(Sender: TObject);
var
  lPerson: TPerson;
begin
  lPerson := TPerson.Create;
  try
    TUtility.LoadFromDatabase(lPerson, dm_Data.FDQuery1, edId.ValueInt);

    edName.Text := lPerson.Name;
    edSurname.Text := lPerson.Surname;
    edAge.ValueInt := lPerson.Age;
    edZipCode.text := lPerson.ZipCode;
    edCity.text := lPerson.City;
    edState.text := lPerson.State;
    cbTitle.ItemIndex := cbTitle.Items.IndexOf(lPerson.Title);

  finally
    lPerson.Free;
  end;
end;

procedure TfrmMain.acProductExecute(Sender: TObject);
var
  lForm: TfrmProduct;
begin
  lForm:= TfrmProduct.Create(nil);
  try
    lForm.ShowModal;
  finally
    lForm.free;
  end;
end;

procedure TfrmMain.acSaveExecute(Sender: TObject);
var
  lPerson: TPerson;
begin
  lPerson := TPerson.Create;
  try
    lPerson.Id := edId.ValueInt; // 0 per nuovo record, >0 per update
    lPerson.Name := edName.Text;
    lPerson.Surname := edSurname.Text;
    lPerson.Age := edAge.ValueInt;
    lPerson.ZipCode := edZipCode.text;
    lPerson.City := edCity.text;
    lPerson.State := edState.text;
    lPerson.Title := cbTitle.Text;

    TUtility.SaveToDatabase(lPerson, dm_Data.FDQuery1);

    ShowMessage('Persona salvata con successo!');
  finally
    lPerson.Free;
  end;
end;

procedure TfrmMain.acSaveUpdate(Sender: TObject);
begin
  acLoad.Enabled := edId.ValueInt > 0;
  acSave.Enabled := TUtility.MandatoryOK(self);
end;

end.
