unit Helpers;

interface
uses
  Commons,
  Attributes,
  System.SysUtils,
  System.Classes,
  System.Rtti,
  System.TypInfo;

type

  TPersonTypeHelper = Record helper for TPersonType
  public
    function GetList: TStrings;
  End;

implementation

function TPersonTypeHelper. GetList: TStrings;
var
  lType: TRttiType;
  lAttr: TCustomAttribute;
  lEnumAttr: EnumeratedAttribute;
  lValues: TArray<string>;
  I: Integer;
begin
  Result := TStringList.Create;

  lType := TRttiContext.Create.GetType(TypeInfo(TPersonType));

  // Cerca l'attributo EnumeratedAttribute
  for lAttr in lType.GetAttributes do
  begin
    if lAttr is EnumeratedAttribute then
    begin
      lEnumAttr := EnumeratedAttribute(lAttr);

      // Splitta la stringa usando la virgola come delimitatore
      lValues := lEnumAttr.Value.Split([',']);

      // Aggiungi i valori alla lista
      for I := 0 to High(lValues) do
        Result.Add(lValues[I]);
      Break;
    end;
  end;

end;

end.
