unit BusinessObjects;

interface

uses
  Attributes;

type

  TBase = Class
  private
    FId: Integer;
  public
    property Id: Integer read FId write FId;
  End;

  // Classe TPerson con gli attributi
  [Table('ancli')]
  TPerson = class(TBase)
  private
    FName: string;
    FSurname: string;
    FAge: Integer;
    FZipCode: string;
    FCity: String;
    FState: String;
    FTitle: String;

  public
    [Column('ancid', True)]
    property Id;

    [Column('ancna')]
    [StringLength(100)]
    [Mandatory]
    property Name: string read FName write FName;

    [Column('ancsu'), StringLength(100), Mandatory]
    property Surname: string read FSurname write FSurname;

    [Column('ancag')]
    property Age: Integer read FAge write FAge;

    [StringLength(5)]
    [Column('anczp')]
    property ZipCode: string read FZipCode write FZipCode;

    [StringLength(100)]
    [Column('ancci')]
    property City: String read FCity write FCity;

    [StringLength(2)]
    [Column('ancst')]
    property State: String read FState write FState;

    [Column('ancti')]
    property Title: String read FTitle write FTitle;
  end;

  [Table('anpro')]
  TProduct = class(TBase)
  private
    FCode: String;
    FPrice: Currency;
    FDescription: String;
    public
    [Column('anpid', True)]
    property Id;

    [Column('anpco')]
    [StringLength(10)]
    [Mandatory]
    property Code: String read FCode write FCode;

    [Column('anpde')]
    [StringLength(10)]
    [Mandatory]
    property Description: String read FDescription write FDescription;

    [Column('anppr')]
    [Mandatory]
    property Price: Currency read FPrice write FPrice;
  end;

implementation

end.
