unit Attributes;

interface

type
  // Definizione dei Custom Attributes
  TableAttribute = class(TCustomAttribute)
  private
    FTableName: string;
  public
    constructor Create(const aTableName: string);
    property TableName: string read FTableName;
  end;

  ColumnAttribute = class(TCustomAttribute)
  private
    FColumnName: string;
    FIsPrimaryKey: Boolean;
  public
    constructor Create(const aColumnName: string; aIsPrimaryKey: Boolean = False);
    property ColumnName: string read FColumnName;
    property IsPrimaryKey: Boolean read FIsPrimaryKey;
  end;

  StringLengthAttribute = class(TCustomAttribute)
  private
    FMaxLength: Integer;
  public
    constructor Create(aMaxLength: Integer);
    property MaxLength: Integer read FMaxLength;
  end;

  StringAttribute = class(TCustomAttribute)
  private
     FValue: String;
  public
    constructor Create(const aValue: String);
    property Value: String read FValue;
  end;

  EnumeratedAttribute = class(StringAttribute);

  MandatoryAttribute = class(TCustomAttribute);

implementation

{ TableAttribute }

constructor TableAttribute.Create(const aTableName: string);
begin
  inherited Create;
  FTableName := aTableName;
end;

{ ColumnAttribute }

constructor ColumnAttribute.Create(const aColumnName: string; aIsPrimaryKey: Boolean);
begin
  inherited Create;
  FColumnName := aColumnName;
  FIsPrimaryKey := aIsPrimaryKey;
end;

{ StringLengthAttribute }

constructor StringLengthAttribute.Create(aMaxLength: Integer);
begin
  inherited Create;
  FMaxLength := aMaxLength;
end;

{ EnumeratedAttribute }

constructor StringAttribute.Create(const aValue: String);
begin
  FValue := aValue
end;

end.
