unit BusinessObjects;

interface

uses
  Attributes;


type
  // Classe TPerson con gli attributi
  [Table('ancli')]
  TPerson = class
  private
    FId: Integer;
    FName: string;
    FSurname: string;
    FAge: Integer;
    FZipCode: string;
    FCity: String;
    FState: String;
  public
    [Column('ancid', True)]
    property Id: Integer read FId write FId;

    [Column('ancna')]
    [StringLength(100)]
    [Mandatory]
    property Name: string read FName write FName;

    [Column('ancsu'), StringLength(100)]
    property Surname: string read FSurname write FSurname;

    [Column('ancag')]
    property Age: Integer read FAge write FAge;

    [StringLength(5)]
    [Column('anczp')]
    property ZipCode: string read FZipCode write FZipCode;

    [StringLength(100)]
    [Column('ancci')]
    property City: String read FCity write FCity;

    [StringLength(2)]
    [Column('ancst')]
    property State: String read FState write FState;
  end;

implementation

end.
