unit MainForm;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, System.Actions, Vcl.ActnList,
  Vcl.StdCtrls, Vcl.NumberBox;

type
  TForm1 = class(TForm)
    btnSave: TButton;
    btnLoad: TButton;
    ActionList1: TActionList;
    acLoad: TAction;
    acSave: TAction;
    edName: TEdit;
    edSurname: TEdit;
    edAge: TNumberBox;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    edId: TNumberBox;
    procedure acLoadExecute(Sender: TObject);
    procedure acSaveExecute(Sender: TObject);
    procedure acSaveUpdate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses
  Utility,
  BusinessObjects,
  dmData;

{$R *.dfm}

procedure TForm1.acLoadExecute(Sender: TObject);
var
  lPerson: TPerson;
begin
  lPerson := TPerson.Create;
  try
    TUtility.LoadFromDatabase(lPerson, dm_Data.FDQuery1, edId.ValueInt);

    edName.Text := lPerson.Name;
    edSurname.Text := lPerson.Surname;
    edAge.ValueInt := lPerson.Age;

//    edZipCode.text := lPerson.ZipCode;
//    edCity.text := lPerson.City;
//    edState.text := lPerson.State;

  finally
    lPerson.Free;
  end;
end;

procedure TForm1.acSaveExecute(Sender: TObject);
var
  lPerson: TPerson;
begin
  lPerson := TPerson.Create;
  try
    lPerson.Id := edId.ValueInt; // 0 per nuovo record, >0 per update
    lPerson.Name := edName.Text;
    lPerson.Surname := edSurname.Text;
    lPerson.Age := edAge.ValueInt;

//    lPerson.ZipCode := edZipCode.text;
//    lPerson.City := edCity.text;
//    lPerson.State := edState.text;

    TUtility.SaveToDatabase(lPerson, dm_Data.FDQuery1);

    ShowMessage('Persona salvata con successo!');
  finally
    lPerson.Free;
  end;
end;

procedure TForm1.acSaveUpdate(Sender: TObject);
begin
  acLoad.Enabled := edId.ValueInt > 0;
  acSave.Enabled := not (Trim(edName.Text).IsEmpty and Trim(edSurname.Text).IsEmpty);
end;

end.
