unit BusinessObjects;

interface

uses
  Attributes;

{ $DEFINE NEW}

type
  // Classe TPerson con gli attributi
  [Table('ancli')]
  TPerson = class
  private
    FId: Integer;
    FName: string;
    FSurname: string;
    FAge: Integer;
{$IFDEF NEW}
    FZipCode: string;
    FCity: String;
    FState: String;
{$ENDIF}

  public
    [Column('ancid', True)]
    property Id: Integer read FId write FId;

    [Column('ancna')]
    property Name: string read FName write FName;

    [Column('ancsu')]
    property Surname: string read FSurname write FSurname;

    [Column('ancag')]
    property Age: Integer read FAge write FAge;

{$IFDEF NEW}
    [StringLength(5)]
    [Column('anczp')]
    property ZipCode: string read FZipCode write FZipCode;

    [StringLength(100)]
    [Column('ancci')]
    property City: String read FCity write FCity;

    [StringLength(2)]
    [Column('ancst')]
    property State: String read FState write FState;
{$ENDIF}

  end;

implementation

end.
