unit BusinessObjects;

interface

uses
  System.SysUtils,
  FireDAC.Comp.Client;

{ $DEFINE NEW}

type
  TPerson = class
  private
    FId: Integer;
    FName: string;
    FSurname: string;
    FAge: Integer;
{$IFDEF NEW}
    FZipCode: string;
    FCity: String;
    FState: String;
{$ENDIF}
  public
    property Id: Integer read FId write FId;
    property Name: string read FName write FName;
    property Surname: string read FSurname write FSurname;
    property Age: Integer read FAge write FAge;
{$IFDEF NEW}
    property ZipCode: string read FZipCode write FZipCode;
    property City: String read FCity write FCity;
    property State: String read FState write FState;
{$ENDIF}
    procedure SaveToDatabase(aQuery: TFDQuery);
    procedure LoadFromDatabase(aQuery: TFDQuery; aId: Integer);
  end;

implementation

{ TPerson }

procedure TPerson.SaveToDatabase(aQuery: TFDQuery);
const
{$IFDEF NEW}
  cSQLUP = '''
    UPDATE ancli SET ancna = %s, ancsu = %s, ancag = %d, anczi = %s,
    ancci = %s, ancst = %s
    WHERE ancid = %d
    ''';

  cSQLIN = '''
    INSERT INTO ancli (ancna, ancsu, ancag, anczi, ancci, ancst)
    VALUES (%s, %s, %d, %s, %s, %s)
    ''';
{$ELSE}
  cSQLUP = '''
    UPDATE ancli SET ancna = %s, ancsu = %s, ancag = %d
    WHERE ancid = %d
    ''';

  cSQLIN = '''
    INSERT INTO ancli (ancna, ancsu, ancag)
    VALUES (%s, %s, %d)
    ''';
{$ENDIF}

var
  lSQL: string;
begin
  aQuery.Close;

  if FId > 0 then
  begin
    // UPDATE
{$IFDEF NEW}
     lSQL := Format(cSQLUP,[QuotedStr(FName), QuotedStr(FSurname), FAge,
               QuotedStr(FZipCode), QuotedStr(FCity), QuotedStr(FState), FId]);
{$ELSE}
     lSQL := Format(cSQLUP,[QuotedStr(FName), QuotedStr(FSurname), FAge, FId]);
{$ENDIF}


  end
  else
  begin
    // INSERT
{$IFDEF NEW}
    lSQL := Format(cSQLIN,[QuotedStr(FName), QuotedStr(FSurname), FAge,
               QuotedStr(FZipCode), QuotedStr(FCity), QuotedStr(FState)]);
{$ELSE}
    lSQL := Format(cSQLIN,[QuotedStr(FName), QuotedStr(FSurname), FAge]);
{$ENDIF}


  end;

  aQuery.SQL.Text := lSQL;
  aQuery.ExecSQL;
end;


procedure TPerson.LoadFromDatabase(aQuery: TFDQuery; aId: Integer);
var
  lSQL: string;
begin
  lSQL := Format('SELECT * FROM ancli WHERE ancid = %d', [aId]);

  aQuery.Close;
  aQuery.Open(lSQL);

  if not aQuery.Eof then
  begin
    FId := aQuery.FieldByName('ancid').AsInteger;
    FName := aQuery.FieldByName('ancna').AsString;
    FSurname := aQuery.FieldByName('ancsu').AsString;
    FAge := aQuery.FieldByName('ancag').AsInteger;

{$IFDEF NEW}
    FZipCode := aQuery.FieldByName('anczi').AsString;
    FCity := aQuery.FieldByName('ancci').AsString;
    FState := aQuery.FieldByName('ancst').AsString;
{$ENDIF}
  end;
end;

end.
