unit WebModuleUnit2;

interface

uses
  System.SysUtils, System.Classes, Web.HTTPApp;

type
  TWebModule2 = class(TWebModule)
    WebSessionManager1: TWebSessionManager;
    WebAuthorizer1: TWebAuthorizer;
    WebFormsAuthenticator1: TWebFormsAuthenticator;
    procedure WebModule2DefaultHandlerAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule2LoginHandlerAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule2PrivateHandlerAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebModule2BasicLoginHandlerAction(Sender: TObject;
      Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
    procedure WebFormsAuthenticator1Authenticate(
      Sender: TCustomWebAuthenticator; Request: TWebRequest; const UserName,
      Password: string; var Roles: string; var Success: Boolean);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

  TDemoUser = class(TInterfacedObject, IWebUser)
  private
    FUserName: string;
    FUserRoles: string;
    FAuthMethod: string;
  public
    { IWebUser }
    function GetUserName: string;
    function GetAuthMethod: string;
    function GetUserRoles: string;

    property UserName: string read GetUserName;
    property AuthMethod: string read GetAuthMethod;
    property UserRoles: string read GetUserRoles;

    constructor Create(const AUserName, AUserRoles: string);
  end;

var
  WebModuleClass: TComponentClass = TWebModule2;

implementation

{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

procedure TWebModule2.WebFormsAuthenticator1Authenticate(
  Sender: TCustomWebAuthenticator; Request: TWebRequest; const UserName,
  Password: string; var Roles: string; var Success: Boolean);
begin
  Roles := 'admin';
  Success := SameText(UserName, 'luca');
end;

procedure TWebModule2.WebModule2BasicLoginHandlerAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  Response.Content :=
    '<html>' +
    '<head><title>Web Server Application</title></head>' +
    '<body>' +
      'Basic login: ' + Request.SessionId +
      '<p>' +
       if Request.Session.Authenticated then 'Auth:' + Request.Session.UserName + ' ' + Request.Session.UserRoles else 'noauth' +
      '</p>' +
    '</body>' +

    '</html>';
end;

procedure TWebModule2.WebModule2DefaultHandlerAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
  Response.Content :=
    '<html>' +
    '<head><title>Web Server Application</title></head>' +
    '<body>' +
      '<h1>Public page</h1> ' +
      '<p><b>SessionId</b>:  ' + Request.SessionId + '</p>' +
       if Assigned(Request.Session) and Request.Session.Authenticated then '<p>User: ' + Request.Session.UserName + '</p><p>Role: ' + Request.Session.UserRoles + '</p>' else '<p>No auth</p>' +
    '</body>' +

    '</html>';
end;

procedure TWebModule2.WebModule2LoginHandlerAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
//  var LUserName := Request.QueryFields.Values['username'];
//  Request.Session.Login(TDemoUser.Create(LUserName, 'Admin'));
end;

procedure TWebModule2.WebModule2PrivateHandlerAction(Sender: TObject;
  Request: TWebRequest; Response: TWebResponse; var Handled: Boolean);
begin
//  if not Request.Session.UserHasRole('admin') then
//    raise EWebNotAuthorized.Create('Not authorized');

  Response.Content :=
    '<html>' +
    '<head><title>Web Server Application</title></head>' +
    '<body><h1>Private resource</h1>' +
      '<p><b>SessionId</b>:  ' + Request.SessionId + '</p>' +
       if Assigned(Request.Session) and Request.Session.Authenticated then '<p>User: ' + Request.Session.UserName + '</p><p>Role: ' + Request.Session.UserRoles + '</p>' else '<p>No auth</p>' +
    '</body>' +

    '</html>';
end;

{ TDemoUser }

constructor TDemoUser.Create(const AUserName, AUserRoles: string);
begin
  inherited Create;
  FUserName := AUserName;
  FUserRoles := AUserRoles;
  FAuthMethod := 'custom';
end;

function TDemoUser.GetAuthMethod: string;
begin
  Result := FAuthMethod;
end;

function TDemoUser.GetUserName: string;
begin
  Result := FUserName;
end;

function TDemoUser.GetUserRoles: string;
begin
  Result := FUserRoles;
end;

end.
