unit Tools.UI.Main;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Net.URLClient,
  System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Server.AiEngines.Core, Winapi.ShellAPI;

type
  TfrmToolsDemo = class(TForm)
    memRequest: TMemo;
    memResponse: TMemo;
    btnSend: TButton;
    procedure btnSendClick(Sender: TObject);
  private
    FEngine: IAIEngine;
  public

    [ChatTool('Return the start date of an event in the ISO format yyyy-mm-dd')]
    function EventStartDate(
      [ChatTool('The name of the event (without spaces or special characters)')]
      const EventName: string
    ): string;

    [ChatTool('Return the number of attendees to an event')]
    function EventAttendees(
      [ChatTool('The name of the event (without spaces or special characters)')]
      const EventName: string
    ): string;

    [ChatTool('Send an e-mail to a specific email address')]
    function SendMail(
      [ChatTool('The email address')]
      const TargetEmail: string;
      [ChatTool('The subject of the email')]
      const Subject: string;
      [ChatTool('The body of the email (max 200 characters)')]
      const Body: string
    ): string;

    constructor Create(AOwner: TComponent); override;
  end;

var
  frmToolsDemo: TfrmToolsDemo;

// Quando comincia il delphiday?
// Quanti giorni di distanza ci sono tra il delphi day e il delphi summit?
// Puoi inviare una mail con gli auguri di natale a paolo@wintech-italia.com?
// Scrivi una mail a paolo@wintech-italia.it in cui gli ricordi quando comincia il delphiday

implementation

{$R *.dfm}

uses
  Dynamo.Core.ServiceLocator;

const
  //EngineName = 'ollama';
  EngineName = 'openai';

{ TForm29 }

procedure TfrmToolsDemo.btnSendClick(Sender: TObject);
var
  LMessages: TArray<IChatMessage>;
begin
  memResponse.Text := '';
  Application.ProcessMessages;
  LMessages := [TAIEngine.CreateUserPayload(memRequest.Text)];
  FEngine.Chat(LMessages, Self,
    procedure (AChat: TChatResponse)
    begin
      memResponse.Text := memResponse.Text + AdjustLineBreaks(AChat.Message.Content);
      Application.ProcessMessages;
    end);
end;

constructor TfrmToolsDemo.Create(AOwner: TComponent);
begin
  inherited;
  FEngine := ServiceLocator.GetClass<IAIEngine>(EngineName);
  //FEngine.ProxySettings := TProxySettings.Create('localhost', 8086)
end;

function TfrmToolsDemo.EventAttendees(const EventName: string): string;
begin
  if SameText(EventName, 'DelphiDay') then
    Result := '101'
  else if SameText(EventName, 'DelphiSummit') then
    Result := '256'
  else
    Result := 'unknown';
end;

function TfrmToolsDemo.EventStartDate(const EventName: string): string;
begin
  if SameText(EventName, 'DelphiDay') then
    Result := '2025-11-19'
  else if SameText(EventName, 'DelphiSummit') then
    Result := '2025-06-05'
  else
    Result := 'unknown';
end;

function TfrmToolsDemo.SendMail(const TargetEmail, Subject,
  Body: string): string;
begin
  ShowMessage(
    'TO: ' + TargetEmail + sLineBreak +
    'SUBJECT: ' + Subject + sLineBreak + sLineBreak +
    Body + sLineBreak
  );
  Result := 'Success!';
end;

end.
