# LLM Project

Welcome to the LLM project for DelphiDay2025!

## Overview

This project explores the integration and usage of Large Language Models (LLMs) within Delphi applications. It aims to provide examples, ideas, and tools to help developers leverage LLMs in their own projects.

## Projects in this Repository

1. `ChatDemo`: A basic chat interface demonstration showing how to integrate LLM capabilities into Delphi applications.
2. `ChatToSQL`: Demonstrates natural language to SQL query conversion using LLMs, allowing users to interact with databases using natural language (requires  [FirebirdSQL](https://www.firebirdsql.org/) standard employee database).
3. `BlobToTableDemo`: Demonstrates how to read unstructured textual content and transform it into structured data formats like JSON or database tables using LLM services.
4. `EmbeddingDemo`: Explores text embeddings for semantic search and content analysis.
5. `RAGDemo`: Implementation of Retrieval-Augmented Generation (RAG), demonstrating how to enhance LLM responses with external knowledge sources (requires PostgreSQL with [vector similarity search](https://github.com/pgvector/pgvector) plugin).

## Requirements

The projects support many LLM through the following SDK:

* DelphiOpenAI: https://github.com/HemulGM/DelphiOpenAI
* DelphiGemini: https://github.com/MaxiDonkey/DelphiGemini
* DelphiAnthropic: https://github.com/MaxiDonkey/DelphiAnthropic
* DelphiMistralAI: https://github.com/MaxiDonkey/DelphiMistralAI

Each LLM provider needs its own API KEY in the appropriate environment variable:

* ANTHROPIC_API_KEY
* GEMINI_API_KEY
* MISTRALAI_API_KEY
* OPENAI_API_KEY

## License

This project is licensed under the MIT License.
