unit RAG.UI.Main;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Server.AiEngines.Core, Winapi.ShellAPI;

type
  TfrmRAGDemo = class(TForm)
    memRequest: TMemo;
    memResponse: TMemo;
    btnSend: TButton;
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    Button2: TButton;
    procedure btnSendClick(Sender: TObject);
    procedure Label1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
  private
    FEngine: IAIEngine;
    function AugmentQuery(const AQuery: string): string;
    procedure AddDocument(const AFileNAme: string);
    procedure DeleteDocument(ADocumentId: Integer);
  public
    constructor Create(AOwner: TComponent); override;
  end;

var
  frmRAGDemo: TfrmRAGDemo;

implementation

{$R *.dfm}

uses
  Dynamo.Core.ServiceLocator, RAG.Core;

const
  //EngineName = 'openai';
  //EngineName = 'mistral';
  EngineName = 'geminiai';
  //EngineName = 'anthropic';
  DomainId = 8;

{ TfrmChatDemo }

procedure TfrmRAGDemo.AddDocument(const AFileNAme: string);
begin
  var LRAG := TRagSystem.Create(FEngine as IEmbedder);
  try
    LRAG.AddDocument(AFileNAme, DomainId);
  finally
    LRAG.Free;
  end;
end;

function TfrmRAGDemo.AugmentQuery(const AQuery: string): string;
begin
  var LRAG := TRagSystem.Create(FEngine as IEmbedder);
  try
    Result := LRAG.GetAugmentedQuery(AQuery, DomainId);
  finally
    LRAG.Free;
  end;
end;

procedure TfrmRAGDemo.btnSendClick(Sender: TObject);
var
  LMessages: TArray<IChatMessage>;
  LQuery: string;
begin
  memResponse.Text := '';
  LQuery := AugmentQuery(memRequest.Text);
  LMessages := LMessages + [TAIEngine.CreateUserPayload(LQuery)];
  FEngine.Chat(LMessages,
    procedure (AChat: TChatResponse)
    begin
      memResponse.Text := memResponse.Text + AdjustLineBreaks(AChat.Message.Content);
      Application.ProcessMessages;
    end);
end;

procedure TfrmRAGDemo.Button1Click(Sender: TObject);
begin
  if OpenDialog1.Execute(Handle) then
  begin
    AddDocument(OpenDialog1.FileName);
  end;
end;

procedure TfrmRAGDemo.Button2Click(Sender: TObject);
begin
  var LDocumentId := StrToIntDef(InputBox(Caption, 'ID del documento da cancellare', ''), -1);
  DeleteDocument(LDocumentId);
end;

constructor TfrmRAGDemo.Create(AOwner: TComponent);
begin
  inherited;
  FEngine := ServiceLocator.GetClass<IAIEngine>(EngineName);
end;

procedure TfrmRAGDemo.DeleteDocument(ADocumentId: Integer);
begin
  var LRAG := TRagSystem.Create(FEngine as IEmbedder);
  try
    LRAG.DeleteDocument(ADocumentId);
  finally
    LRAG.Free;
  end;
end;

procedure TfrmRAGDemo.Label1Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', 'https://platform.openai.com/tokenizer', '', '', 0);
end;

end.
