unit Embedding.UI.Main;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Server.AiEngines.Core;

type
  TForm29 = class(TForm)
    memRequest: TMemo;
    btnSend: TButton;
    memResponse: TMemo;
    procedure btnSendClick(Sender: TObject);
  private
    FEmbedder: IEmbedder;
  public
    constructor Create(AOwner: TComponent); override;
  end;

var
  Form29: TForm29;

implementation

{$R *.dfm}

uses
  Dynamo.Core.ServiceLocator;

const
  EngineName = 'openai';
//  EngineName = 'geminiai';
//  EngineName = 'ollama';

procedure TForm29.btnSendClick(Sender: TObject);
begin
  var LEmbedder := FEmbedder.GetEmbeddingFromString(memRequest.Text);
  memResponse.Text := EmbeddingToStr(LEmbedder);
end;

constructor TForm29.Create(AOwner: TComponent);
begin
  inherited;
  FEmbedder := ServiceLocator.GetClass<IEmbedder>(EngineName);
end;

end.
