unit ChatToSQL.UI.Main;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Error, FireDAC.UI.Intf, FireDAC.Phys.Intf, FireDAC.Stan.Def,
  FireDAC.Stan.Pool, FireDAC.Stan.Async, FireDAC.Phys, FireDAC.Phys.FB,
  FireDAC.Phys.FBDef, FireDAC.VCLUI.Wait, Data.DB, FireDAC.Comp.Client,
  FireDAC.Stan.Param, FireDAC.DatS, FireDAC.DApt.Intf, FireDAC.DApt, Vcl.Grids,
  Vcl.DBGrids, FireDAC.Comp.DataSet, Vcl.StdCtrls, Server.AiEngines.Core,
  System.IOUtils;

type
  TfrmChatToSQL = class(TForm)
    FDConnection1: TFDConnection;
    FDQuery1: TFDQuery;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    memRequest: TMemo;
    btnSend: TButton;
    memResponse: TMemo;
    procedure btnSendClick(Sender: TObject);
  private
    FEngine: IAIEngine;
    FRequestTemplate: string;
    procedure ExecuteSQL;
  public
    constructor Create(AOwner: TComponent); override;
  end;

var
  frmChatToSQL: TfrmChatToSQL;

implementation

{$R *.dfm}

uses
  Dynamo.Core.ServiceLocator;

const
//  EngineName = 'ollama';
//  EngineName = 'geminiai';
//  EngineName = 'mistral';
  EngineName = 'anthropic';

// estrai tutti i dipendenti che vivono in USA

// dammi una lista di tutti gli impiegati che sono a capo di un progetto

// dimmi i tipi di lavoro dove ci sono impiegati che guadagnano almeno $100.000

//!! fammi vedere per ogni tipo di lavoro lo stipendio minimo, massimo e la media (non voglio vedere il codice del lavoro la descrizione) ma la media deve essere letta da dagli stipendi effettivi

procedure TfrmChatToSQL.btnSendClick(Sender: TObject);
var
  LMessages: TArray<IChatMessage>;
  LFullRequest: string;
begin
  LFullRequest := StringReplace(FRequestTemplate, '%QUESTION%', memRequest.Text, []);
  memResponse.Text := LFullRequest;

  memResponse.Text := '';
  LMessages := LMessages + [TAIEngine.CreateUserPayload(LFullRequest)];
  FEngine.Chat(LMessages,
    procedure (AChat: TChatResponse)
    begin
      memResponse.Text := memResponse.Text + AdjustLineBreaks(AChat.Message.Content);
      Application.ProcessMessages;
      if AChat.Done then
        ExecuteSQL;
    end);
end;

constructor TfrmChatToSQL.Create(AOwner: TComponent);
begin
  inherited;
  FEngine := ServiceLocator.GetClass<IAIEngine>(EngineName);

  FRequestTemplate := TFile.ReadAllText('..\..\SqlToChatTemplate.txt');
  FDConnection1.Connected := True;
end;

procedure TfrmChatToSQL.ExecuteSQL;
begin
  FDQuery1.SQL.Text := memResponse.Text;
  FDQuery1.Open;
end;

end.
