unit ChatDemo.UI.Main;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, Vcl.StdCtrls, Server.AiEngines.Core, Winapi.ShellAPI;

type
  TfrmChatDemo = class(TForm)
    memRequest: TMemo;
    memResponse: TMemo;
    btnSend: TButton;
    Label1: TLabel;
    procedure btnSendClick(Sender: TObject);
    procedure Label1Click(Sender: TObject);
  private
    FEngine: IAIEngine;
  public
    constructor Create(AOwner: TComponent); override;
  end;

var
  frmChatDemo: TfrmChatDemo;

implementation

{$R *.dfm}

uses
  Dynamo.Core.ServiceLocator;

const
  EngineName = 'openai';
  //EngineName = 'mistral';
   //EngineName = 'geminiai';
  //EngineName = 'anthropic';

{ TForm29 }

procedure TfrmChatDemo.btnSendClick(Sender: TObject);
var
  LMessages: TArray<IChatMessage>;
begin
  memResponse.Text := '';
  LMessages := LMessages + [TAIEngine.CreateUserPayload(memRequest.Text)];
  FEngine.Chat(LMessages,
    procedure (AChat: TChatResponse)
    begin
      memResponse.Text := memResponse.Text + AdjustLineBreaks(AChat.Message.Content);
      Application.ProcessMessages;
    end);
end;

constructor TfrmChatDemo.Create(AOwner: TComponent);
begin
  inherited;
  FEngine := ServiceLocator.GetClass<IAIEngine>(EngineName);
end;

procedure TfrmChatDemo.Label1Click(Sender: TObject);
begin
  ShellExecute(Handle, 'open', 'https://platform.openai.com/tokenizer', '', '', 0);
end;

end.
