unit BlobToTable.UI.Main;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants, System.Classes, Vcl.Graphics,
  Vcl.Controls, Vcl.Forms, Vcl.Dialogs, FireDAC.Stan.Intf, FireDAC.Stan.Option,
  FireDAC.Stan.Error, FireDAC.UI.Intf, FireDAC.Phys.Intf, FireDAC.Stan.Def,
  FireDAC.Stan.Pool, FireDAC.Stan.Async, FireDAC.Phys, FireDAC.Phys.FB,
  FireDAC.Phys.FBDef, FireDAC.VCLUI.Wait, Data.DB, FireDAC.Comp.Client,
  FireDAC.Stan.Param, FireDAC.DatS, FireDAC.DApt.Intf, FireDAC.DApt, Vcl.Grids,
  Vcl.DBGrids, FireDAC.Comp.DataSet, Vcl.StdCtrls, Server.AiEngines.Core,
  System.IOUtils, Vcl.DBCtrls, System.JSON, System.Generics.Collections;

type
  TfrmChatToSQL = class(TForm)
    FDConnection1: TFDConnection;
    FDQuery1: TFDQuery;
    DataSource1: TDataSource;
    DBGrid1: TDBGrid;
    btnSend: TButton;
    DBMemo1: TDBMemo;
    grdData: TStringGrid;
    memResponse: TMemo;
    procedure btnSendClick(Sender: TObject);
  private
    FEngine: IAIEngine;
    FRequestTemplate: string;
    procedure FillDataGrid;
  public
    constructor Create(AOwner: TComponent); override;
  end;

var
  frmChatToSQL: TfrmChatToSQL;

implementation

{$R *.dfm}

uses
  Dynamo.Core.ServiceLocator;

const
//  EngineName = 'ollama';
//  EngineName = 'geminiai';
//  EngineName = 'mistral';
  EngineName = 'anthropic';

  BasePrompt = '''
I dati che seguono sono diverse righe di descrizioni di movimenti bancari.
Cerca di trovare i dati comuni e creami un array json con un elemento per
ogni movimento. Deve proprio essere un array non un oggetto contente un array.
Ogni riga dell'array json deve avere gli stessi campi che deciderai in base ai
dati presenti all'intero della descrizione dei movimenti.
Se vedi delle date formattale come dd/mm/yyyy.
In particolare cerca il numero di polizza, che deve essere preceduto da un
testo simile a "polizza", "poliza numero", ecc.
E' importante che nella risposta ci sia solo il json senza formattazione
markdown, senza in introduzione testuale ecc. Il testo che generi deve cominciare
con una parentesi quadra aperta [.

Seguono i movimenti:
''';

procedure TfrmChatToSQL.btnSendClick(Sender: TObject);
var
  LMessages: TArray<IChatMessage>;
  LFullRequest: string;
begin
  LFullRequest := BasePrompt + sLineBreak;
  FDQuery1.First;
  while not FDQuery1.Eof do
  begin
    LFullRequest := LFullRequest + 'Movimento ' + FDQuery1.FieldByName('ID').AsString + sLineBreak;
    LFullRequest := LFullRequest + FDQuery1.FieldByName('TEXT').AsString + sLineBreak + sLineBreak;
    FDQuery1.Next;
  end;
  //memResponse.Text := LFullRequest;

  //memResponse.Text := '';
  LMessages := LMessages + [TAIEngine.CreateUserPayload(LFullRequest)];
  FEngine.Chat(LMessages,
    procedure (AChat: TChatResponse)
    begin
      memResponse.Text := memResponse.Text + AdjustLineBreaks(AChat.Message.Content);
      Application.ProcessMessages;
      if AChat.Done then
        FillDataGrid;
    end);
end;

constructor TfrmChatToSQL.Create(AOwner: TComponent);
begin
  inherited;
  FEngine := ServiceLocator.GetClass<IAIEngine>(EngineName);

  FRequestTemplate := TFile.ReadAllText('..\..\SqlToChatTemplate.txt');
  FDConnection1.Connected := True;
  FDQuery1.Open;
end;

procedure TfrmChatToSQL.FillDataGrid;
begin
  var LJSONString := memResponse.Text;
  LJSONString := StringReplace(LJSONString, '```json', '', [rfReplaceAll, rfIgnoreCase]);
  LJSONString := StringReplace(LJSONString, '```', '', [rfReplaceAll, rfIgnoreCase]);
  var R := 0;
  var LJson := TJSONArray.ParseJSONValue(LJSONString, False, True) as TJSONArray;
  try
    grdData.RowCount := LJson.Count + 1;
    grdData.ColCount := 20;
    grdData.DefaultColWidth := 200;
    grdData.ColWidths[0] := 10;
    for var LJsonItem in LJson do
    begin
      var LJsonObject := LJsonItem as TJSONObject;
      for var C := 0 to LJsonObject.Count - 1 do
      begin
        if R = 0 then
          grdData.Cells[C + 1, R] := LJsonObject.Pairs[C].JsonString.Value;

        grdData.Cells[C + 1, R + 1] := LJsonObject.Pairs[C].JsonValue.Value;
      end;
      Inc(R);
    end;
  finally
    LJson.Free;
  end;

end;

end.
