unit AreaCalculator;

interface

uses
  System.Classes,
  Rectangle, Circle;

type

{ TAreaCalculator }

  TAreaCalculator = class
  public
    function Area(AShapes: array of TObject): Integer;
  end;

implementation

{ TAreaCalculator }

function TAreaCalculator.Area(AShapes: array of TObject): Integer;
var
  S: TObject;
  R: TRectangle;
  C: TCircle;
begin
  Result := 0;
  for S in AShapes do
  begin
    if S is TRectangle then
    begin
      R := TRectangle(S);
      Result := Result + (R.Width * R.Height);
    end;
    if S is TCircle then
    begin
      C := TCircle(S);
      Result := Result + Round(C.Radius * C.Radius * Pi());
    end;
  end;
 end;

end.
