unit ClickListener;

interface

type

{ IClickListener }

  IClickListener = interface
    ['{FDDC3779-DECA-49E1-84A9-A84002D23392}']
    procedure OnClick;
    procedure OnDoubleClick;
    procedure OnLongClick;
  end;

{ TSimpleClickListener }

  TSimpleClickListener = class(TInterfacedObject, IClickListener)
  public
    procedure OnClick;
    procedure OnDoubleClick;
    procedure OnLongClick;
  end;

implementation

{ TSimpleClickListener }

procedure TSimpleClickListener.OnClick;
begin
  Writeln('Clicked!');
end;

procedure TSimpleClickListener.OnDoubleClick;
begin
  // ignored
end;

procedure TSimpleClickListener.OnLongClick;
begin
  // ignored
end;

end.
